using System;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary
{
	/// <summary>
	/// The exception might be thrown because of problems that may occur
	/// while reading and parsing VistALink configuration from host application
	/// configuration file.
	/// </summary>
	public class VistALinkConfigurationException : FlatMediumParseException
	{
		/// <summary>
		/// Default parameterless constructor. Should be avoided whenever possible.
		/// </summary>
		public VistALinkConfigurationException() 
			: base() {}

		/// <summary>
		/// This constructor allows specifying an error message upon throwing an exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		public VistALinkConfigurationException( string message )
			: base( message ) {}

		/// <summary>
		/// This constructor allows adding inner exception that caused this exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		/// <param name="innerException">Inner exception that caused this exception.</param>
		public VistALinkConfigurationException( string message, Exception innerException )
			: base( message, innerException ) {}
	}
}
